bl_info = {
    "name": "Camera Tab Switch Timer",
    "author": "InDizains",
    "version": (1, 0),
    "blender": (4, 0, 0),
    "location": "Properties Editor",
    "description": "Automatically switches to Camera Data tab when a camera is selected",
    "category": "3D View"
}

import bpy

_last_active_object = None
_timer_running = False


def camera_tab_watcher():
    global _last_active_object

    current = bpy.context.active_object
    if current != _last_active_object:
        _last_active_object = current
        if current and current.type == 'CAMERA':
            for window in bpy.context.window_manager.windows:
                for area in window.screen.areas:
                    if area.type == 'PROPERTIES':
                        for space in area.spaces:
                            if space.type == 'PROPERTIES':
                                space.context = 'DATA'
                                area.tag_redraw()
    return 0.5


def register():
    global _timer_running
    if not _timer_running:
        bpy.app.timers.register(camera_tab_watcher)
        _timer_running = True


def unregister():
    global _timer_running
    _timer_running = False  # Stop any further registration
    # Note: Cannot "unregister" a timer directly, it will stop after returning None.


if __name__ == "__main__":
    register()
